USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_FutureDischarge]    Script Date: 6/14/2016 9:15:23 AM ******/
DROP PROCEDURE [dbo].[usp_Rpt_FutureDischarge]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_FutureDischarge]    Script Date: 6/14/2016 9:15:23 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


--exec usp_Rpt_FutureDischarge @WARDGROUP_ID=8267,@START_DATE='2004-05-05 00:00:01',@END_DATE='2016-05-05 23:59:59',@USER_NAME=N'DNS',@FACILITY_EXTENSION=N'69378E0F-B210-493B-B2A1-2130C9F7F394',@PATIENT_IDENTIFIER=NULL,@TIME_ZONE_MINUTES_OFFSET=0
CREATE PROCEDURE [dbo].[usp_Rpt_FutureDischarge] 
	--@WARD_ID INT = NULL,
	@WARDGROUP_ID INT = NULL,
	@START_DATE DATETIME = NULL,
	@END_DATE DATETIME = NULL,
	@USER_NAME NVARCHAR(500)= NULL,
	@FACILITY_EXTENSION NVARCHAR(250),
	@PATIENT_IDENTIFIER NVARCHAR(250) = NULL,
	@TIME_ZONE_MINUTES_OFFSET INT
	
AS
BEGIN
	
	IF @START_DATE > @END_DATE
		RAISERROR ('The start date is greater than the end date. Please correct.', 18, 13)
	ELSE
	BEGIN

	/*		SELECT NULL AS WARD_NAME,
					   NULL AS BED_NAME,
					   NULL AS PATIENT_NAME,
					   NULL AS PT_SHORT,
					   NULL AS APPOINTMENT_DATE,
					   NULL AS CURRENT_STATUS,
					   NULL AS SIGNED_DATE,
					   NULL AS DISCHARGED_DATE,
					   NULL AS SIGNED_DIFF,
					   NULL AS MOVEMENT_DATE,
					   NULL AS APPT_DIFF,
					   NULL AS CLICNIC_NAME
	*/

	DECLARE @SQL_SELECT NVARCHAR(4000), @SQL_WHERE NVARCHAR(4000), @SQL NVARCHAR(4000)
	
	set @START_DATE = DATEADD (minute , -@TIME_ZONE_MINUTES_OFFSET , @START_DATE );
	set @END_DATE = DATEADD (minute , -@TIME_ZONE_MINUTES_OFFSET , @END_DATE );
-- create permission table
	CREATE TABLE #PERMISSION
        (
         DIM_ORGANIZATION_ID INT,
         DIM_WARD_ID INT
        )
    --insert permission for the user
    INSERT INTO #PERMISSION 
		SELECT * FROM dbo.ufn_GetPermissionByUserName(@USER_NAME)
			CREATE NONCLUSTERED INDEX [DIM_ORGANIZATION_ID] ON #PERMISSION ([DIM_ORGANIZATION_ID] ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON)
			CREATE NONCLUSTERED INDEX DIM_WARD_ID ON #PERMISSION (DIM_WARD_ID ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON) ;
	
	
	
	DECLARE @FACILITY_ID INT
	--get facility id
	SET @FACILITY_ID = dbo.ufn_GetFacilityIdByIdentifier(@FACILITY_EXTENSION);
	
	--check if the user has permission for the facility		
	IF EXISTS(SELECT 1 
			  FROM #PERMISSION
			  WHERE DIM_ORGANIZATION_ID = @FACILITY_ID)
		BEGIN
			
			CREATE TABLE #WARD
			(
				ID INT
			)
			CREATE NONCLUSTERED INDEX WARD_ID ON #WARD(ID ASC)
			
			IF @END_DATE IS NULL
				SELECT @START_DATE = CAST(CONVERT(VARCHAR(10),GETUTCDATE(),101) + ' 00:01' as datetime)
	
			IF @WARDGROUP_ID = -1 OR @WARDGROUP_ID IS NULL
				INSERT INTO #WARD(ID)
				SELECT WARD.ID FROM dbo.ufn_GetWardsByFacilityId(@FACILITY_ID) AS WARD
				INNER JOIN dbo.DIM_WARD AS ACTIVE_WARD ON ACTIVE_WARD.ID = WARD.ID
				WHERE ACTIVE_WARD.STATUS = 'active'
			ELSE
					INSERT INTO #WARD(ID)
					SELECT DIM_WARD_ID FROM dbo.GROUP_WARD_ORGANIZATION GWO
					WHERE DIM_ORGANIZATION_ID = @WARDGROUP_ID
			
			CREATE TABLE #PATIENT(DIM_PATIENT_ID INT, DIM_BED_ID INT, VISTA_SITE_DIM_ORGANIZATION_ID INT)
			INSERT INTO #PATIENT(DIM_PATIENT_ID, VISTA_SITE_DIM_ORGANIZATION_ID, DIM_BED_ID)
			SELECT EVN.DIM_PATIENT_ID, EVN.VISTA_SITE_DIM_ORGANIZATION_ID, EVN.DIM_BED_ID
			FROM FACT_ADMISSION_EVN AS EVN
			INNER JOIN (
			SELECT MAX(CAST(EVN.IEN AS BIGINT)) AS IEN, EVN.DIM_PATIENT_ID, EVN.VISTA_SITE_DIM_ORGANIZATION_ID
			FROM FACT_ADMISSION_EVN AS EVN
			INNER JOIN #WARD AS WARD ON WARD.ID = EVN.DIM_WARD_ID
			WHERE EVN.HAS_DISCHARGE = 0 AND EVN.DIM_BED_ID IS NOT NULL
			GROUP BY EVN.DIM_PATIENT_ID, EVN.VISTA_SITE_DIM_ORGANIZATION_ID) MAX_PATIENT
			ON MAX_PATIENT.VISTA_SITE_DIM_ORGANIZATION_ID = EVN.VISTA_SITE_DIM_ORGANIZATION_ID
			AND MAX_PATIENT.DIM_PATIENT_ID = EVN.DIM_PATIENT_ID
			AND MAX_PATIENT.IEN = CAST(EVN.IEN AS BIGINT)

			SET @SQL_SELECT = 'SELECT WARD.NAME AS WARD_NAME,
				   BED.NAME AS BED_NAME,
				   PATIENT.LAST_NAME + '' '' + RIGHT(PATIENT.SSN,4) as PATIENT_NAME,
				   LEFT(PATIENT.LAST_NAME,1) + RIGHT(PATIENT.SSN,4) as PT_SHORT,
					CONVERT(VARCHAR, DATEADD (minute, ' + CAST(@TIME_ZONE_MINUTES_OFFSET AS varchar) + ', DISCHARGE.APPOINTMENT_DATE ), 101) + '' '' + 
					CONVERT(VARCHAR(5), DATEADD (minute, ' + CAST(@TIME_ZONE_MINUTES_OFFSET AS varchar) + ', DISCHARGE.APPOINTMENT_DATE ), 108) AS APPOINTMENT_DATE,
				   DISCHARGE.STATUS AS CURRENT_STATUS,
				   CONVERT(VARCHAR, DATEADD (minute, ' + CAST(@TIME_ZONE_MINUTES_OFFSET AS varchar) + ', DISCH_REQ.SIGNED_DATE ), 101) + '' '' + 
						CONVERT(VARCHAR(5), DATEADD (minute, ' + CAST(@TIME_ZONE_MINUTES_OFFSET AS varchar) + ', DISCH_REQ.SIGNED_DATE ), 108) AS SIGNED_DATE,
				   CONVERT(VARCHAR, DATEADD (minute, ' + CAST(@TIME_ZONE_MINUTES_OFFSET AS varchar) + ', DISCHARGE_EVN.DISCHARGED_DATE ), 101) + '' '' + 
						CONVERT(VARCHAR(5), DATEADD (minute, ' + CAST(@TIME_ZONE_MINUTES_OFFSET AS varchar) + ', DISCHARGE_EVN.DISCHARGED_DATE ), 108) AS DISCHARGED_DATE,
				   CONVERT(VARCHAR, DATEADD (minute, ' + CAST(@TIME_ZONE_MINUTES_OFFSET AS varchar) + ', DISCHARGE_EVN.DISCHARGED_DATE ), 101) + '' '' + 
				   CONVERT(VARCHAR(5), DATEADD (minute, ' + CAST(@TIME_ZONE_MINUTES_OFFSET AS varchar) + ', MOVEMENT_EVN.MOVEMENT_DATE ), 108) AS MOVEMENT_DATE,
	 			  dbo.ufn_GetDateDiff(MOVEMENT_EVN.MOVEMENT_DATE ,DISCHARGE.APPOINTMENT_DATE ) AS APPT_DIFF,
				  dbo.ufn_GetDateDiff(DISCH_REQ.SIGNED_DATE, MOVEMENT_EVN.MOVEMENT_DATE) AS SIGNED_DIFF,
				   HOSPITAL_LOCATION.NAME AS CLICNIC_NAME
			FROM dbo.FACT_DISCHARGE_INT AS DISCHARGE
				INNER JOIN dbo.DIM_HOSPITAL_LOCATION_APPOINTMENT AS HOSPITAL_APPOINTMENT ON DISCHARGE.HOSPITAL_LOCATION_DIM_ORGANIZATION_ID = HOSPITAL_APPOINTMENT.HOSPITAL_LOCATION_DIM_ORGANIZATION_ID AND 
					HOSPITAL_APPOINTMENT.FACILITY_DIM_ORGANIZATION_ID = ''' + cast(@FACILITY_ID as varchar) + ''' 
				INNER JOIN #WARD AS W ON W.ID = DISCHARGE.DIM_WARD_ID
				INNER JOIN dbo.DIM_WARD AS WARD ON WARD.ID = W.ID
				INNER JOIN #PATIENT AS PAT ON PAT.DIM_PATIENT_ID = DISCHARGE.DIM_PATIENT_ID
				INNER JOIN dbo.DIM_BED AS BED ON BED.ID = PAT.DIM_BED_ID
				INNER JOIN dbo.DIM_PATIENT AS PATIENT ON PATIENT.ID = PAT.DIM_PATIENT_ID 
				LEFT JOIN dbo.DIM_ORGANIZATION AS HOSPITAL_LOCATION ON HOSPITAL_LOCATION.ID = HOSPITAL_APPOINTMENT.HOSPITAL_LOCATION_DIM_ORGANIZATION_ID
			    LEFT JOIN DBO.FACT_DISCHARGE_REQ AS DISCH_REQ ON DISCH_REQ.ID = 
							  (SELECT MAX(ID) AS ID
							   FROM DBO.FACT_DISCHARGE_REQ AS DISCH_REQ 
							   WHERE DISCH_REQ.DIM_PATIENT_ID = DISCHARGE.DIM_PATIENT_ID
							   AND DISCH_REQ.VISTA_SITE_DIM_ORGANIZATION_ID = DISCHARGE.VISTA_SITE_DIM_ORGANIZATION_ID
							   AND ORDERED_DATE BETWEEN '''+ CONVERT(VARCHAR(25), @START_DATE, 126) + 
							   ''' AND ''' + CONVERT(VARCHAR(30), DATEADD(ms, -3,  @END_DATE + 1)) + ''' )
				LEFT JOIN DBO.FACT_DISCHARGE_EVN AS DISCHARGE_EVN ON DISCHARGE_EVN.ID =
							  (SELECT MAX(ID) AS ID
							  FROM DBO.FACT_DISCHARGE_EVN AS DISCH_EVN
							  WHERE DISCH_EVN.DIM_PATIENT_ID =DISCHARGE.DIM_PATIENT_ID
							  AND DISCH_EVN.VISTA_SITE_DIM_ORGANIZATION_ID = DISCHARGE.VISTA_SITE_DIM_ORGANIZATION_ID
							  AND ENTERED_DATE BETWEEN '''+ CONVERT(VARCHAR(25), @START_DATE, 126) + 
							   ''' AND ''' + CONVERT(VARCHAR(30), DATEADD(ms, -3,  @END_DATE + 1)) + ''' )
				LEFT JOIN DBO.FACT_MOVEMENT_EVN AS MOVEMENT_EVN ON DISCHARGE_EVN.ID =
							  (SELECT MAX(ID) AS ID
							  FROM DBO.FACT_MOVEMENT_EVN AS MOVEMENT_EVN
							  WHERE MOVEMENT_EVN.DIM_PATIENT_ID =DISCHARGE.DIM_PATIENT_ID
							  AND MOVEMENT_EVN.VISTA_SITE_DIM_ORGANIZATION_ID = DISCHARGE.VISTA_SITE_DIM_ORGANIZATION_ID
							  AND ENTERED_DATE BETWEEN '''+ CONVERT(VARCHAR(25), @START_DATE, 126) + 
							   ''' AND ''' + CONVERT(VARCHAR(30), DATEADD(ms, -3,  @END_DATE + 1)) + ''' )'

			SET @SQL_WHERE = ' WHERE DISCHARGE.STATUS NOT LIKE ''%CANCELLED%'' AND DISCHARGE.STATUS NOT LIKE ''%DISCONTINUED%'' AND 
							 DISCHARGE.STATUS NOT LIKE ''%COMPLETE%'' AND DISCHARGE.IS_ACTIVE = 1 '
				
			IF @PATIENT_IDENTIFIER IS NOT NULL
				SET @SQL_WHERE += ' AND PATIENT.SOURCE_ID = ''' + @PATIENT_IDENTIFIER + ''''
			
			IF @END_DATE IS NOT NULL
				SET @SQL_WHERE += ' AND DISCHARGE.APPOINTMENT_DATE BETWEEN ''' + CONVERT(VARCHAR(25), @START_DATE, 126) + ''' AND ''' + CONVERT(VARCHAR(25), @END_DATE, 126) + ''''
			ELSE
				SET @SQL_WHERE += ' AND DISCHARGE.APPOINTMENT_DATE > ''' + CONVERT(VARCHAR(25), @START_DATE, 126) + ''''
				
			SET @SQL = @SQL_SELECT + @SQL_WHERE
					
			EXECUTE sp_executesql @SQL 
			
			DROP TABLE #WARD
			DROP TABLE #PATIENT					
				
		END
	--ELSE
	--	BEGIN
	--			SELECT NULL AS WARD_NAME,
	--				   NULL AS BED_NAME,
	--				   NULL AS PATIENT_NAME,
	--				   NULL AS PT_SHORT,
	--				   NULL AS APPOINTMENT_DATE,
	--				   NULL AS CURRENT_STATUS,
	--				   NULL AS CLICNIC_NAME
	--	END

	DROP TABLE #PERMISSION	
	
	END --error	
END


GO


